package editor;

import java.awt.Color;
import java.util.ArrayList;

import editor.RoomEditorPanel.SpawnPointAndDepth;

public class ConveyorLoadData {
	
	private char dir;
	private int speed;
	private int width;
	private int height;
	private Boolean isPassThru;
	private String[] images;
	private Color[] transparentColors;
	
	private ArrayList<SpawnPointAndDepth> spawnPoints;
	
	
	public ConveyorLoadData() {
		spawnPoints = new ArrayList<SpawnPointAndDepth>();
	}


	public char getDir() {
		return dir;
	}


	public void setDir(char dir) {
		this.dir = dir;
	}


	public int getSpeed() {
		return speed;
	}


	public void setSpeed(int speed) {
		this.speed = speed;
	}


	public int getWidth() {
		return width;
	}


	public void setWidth(int width) {
		this.width = width;
	}


	public int getHeight() {
		return height;
	}


	public void setHeight(int height) {
		this.height = height;
	}


	public Boolean getIsPassThru() {
		return isPassThru;
	}


	public void setIsPassThru(Boolean isPassThru) {
		this.isPassThru = isPassThru;
	}


	public String[] getImages() {
		return images;
	}


	public void setImages(String[] images) {
		this.images = images;
	}


	public ArrayList<SpawnPointAndDepth> getSpawnPoints() {
		return spawnPoints;
	}


	public Color[] getTransparentColors() {
		return transparentColors;
	}


	public void setTransparentColors(Color[] transparentColors) {
		this.transparentColors = transparentColors;
	}
	
	
	public void addSpawnPoint(SpawnPointAndDepth p) {
		int spawnPointsSize = spawnPoints.size();
		
		for(int i = 0; i < spawnPoints.size(); i++) {
			if(spawnPoints.get(i).depth > p.depth) {
				spawnPoints.add(i, p);
				i = spawnPoints.size();
			}
		}
		
		if(spawnPointsSize == spawnPoints.size()) {
			spawnPoints.add(p);
		}
	}
	
}
